
%% Prepare Dataset that contains the average spectrum and m/z values
mznames = {};
N_Masses = size(peak_list,1);
for i=1:N_Masses
   mznames{i} = num2str(peak_list(i,1)); 
end

%% Calculate average spectrum per cluster for all identified subpop.
Dataset_Values = [];
current_dir  = pwd;
clinical_data_Edited = dataset('File',strcat(plots_dir,'\', 'LOU_jdata_', num2str(LOUT_nr_comps), '.txt'));
OrganizedData_Names = SubpopulationsOfPatients_WithNames(clinical_data_Edited);

for i = 1:length(SelectedSubpop)
Cluster_Mask = Visualize_tSNE_2DImage((IDXs_Values==SelectedSubpop(i)),S(1),S(2),indxoo);
Avg_spect = Average_Spectrum(Folded_Measurements,Cluster_Mask,goodlist,pixel_to_sample_ID);
[mrow, mcol] = find(isnan(Avg_spect));
Avg_spect(mrow, mcol)=0;
Avg_Spectrum_PerCluster(:,:,i) = Avg_spect;
close;
msdata_average=  dataset((Clinical_data.Sample_ID), {Avg_Spectrum_PerCluster(:,:,i),mznames{:}});
jdata_ALL_SubPoP = join(msdata_average,OrganizedData_Names, 'LeftKeys', 'Var1' ,  'Rightkeys', 'Name_Patient', 'Type', 'inner');
Dataset_Values = cat(1,Dataset_Values,jdata_ALL_SubPoP);
end


%% Select only values belongs to a certain subpopulation

for i = 1:length(SelectedSubpop)
Selected_Sub = SelectedSubpop(i);
start_v = 1 + (i-1)*(size(Avg_spect,1)-1); %N_Patients = size(Avg_spect,1)-1; NOTE (-1) is added beacuse LOUT
end_v = i*(size(Avg_spect,1)-1);
Retrieved_Dataset = Dataset_Values(start_v:end_v,:);
Sub_V = evalin('base', strcat('Retrieved_Dataset.Subpop_',num2str(Selected_Sub)));
Index_Sub = find(Sub_V~=0);
% Status_1(1:length(Index_Sub)) = i;

% %============= If we want to use Special Labeling System==========
if (MultiClass_MultiLabeling == 1)
    Status_1(1:length(Index_Sub)) = i;
else
    %===== Binary or Triple Labeling =========== 
    if(Triple_Labeling == 1)
        %==============The following for MultiClass SAM==========
        if(ismember(Selected_Sub,High_Surv)) % High Suvival: Label=3
            Status_1(1:length(Index_Sub)) = 3;
        elseif(ismember(Selected_Sub,Low_Surv))  % Low Suvival: Label=2
            Status_1(1:length(Index_Sub)) = 1;
        else
            Status_1(1:length(Index_Sub)) = 2; %Medium Survival: Label = 2
        end
    else
        %==============The following for binary SAM==========
        if(ismember(Selected_Sub,Low_Surv)) % Low Suvival: Label=1
            Status_1(1:length(Index_Sub)) = 1;
        else
            Status_1(1:length(Index_Sub)) = 2;
        end
    end
end
% %============= End of Special Labeling System ==========

Status = Status_1';
Status_V= dataset(Status);
Retrieved_MZ_Subpop = [Retrieved_Dataset(Index_Sub,2:83),Status_V];

if (i>1)
MZ_Average_ConcatenatedSubpop = cat(1,MZ_Average_ConcatenatedSubpop,Retrieved_MZ_Subpop);
else
    MZ_Average_ConcatenatedSubpop = Retrieved_MZ_Subpop;
end
clear Status_1 Status Status_V
end
%%
export(MZ_Average_ConcatenatedSubpop, 'file', 'jdata_AverageSpectrum.txt');
if (length(SelectedSubpop)==2)
    flag = 0;
else
    flag = 1;
end
SAM_Gastric_PairedTest
clear Avg_Spectrum_PerCluster 
